Summary: A Perl script for performing unattended incremental backups.
Name: dobackup
Version: 4.28
Release: 1
License: GPL
Vendor: Webcon, Inc.
Group: Applications/Archiving
URL: http://www.webcon.ca/opensource/dobackup/
Source: http://www.webcon.ca/opensource/dobackup/dobackup-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
Packager: dobackup@webcon.ca

# Disable brain dead perl-specific find-requires.
AutoReq: no
Requires: perl >= 5.6.0, perl(Config::IniFiles)
BuildArchitectures: noarch

%description
A flexible Perl script to handle unattended incremental backups of multiple
servers. Handles multiple media sets with automatic media preparation and
rotation, configurable 'what-to-backup', global exclusion patterns, user
settable 'don't-backup-this-directory' metafiles. Design goal:
zero-maintenance, nothing to do except change the media when told.

%prep
%setup -q

#%build
#echo "What, me? Build? Go 'way witcha!"

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf ${RPM_BUILD_ROOT}

mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}
install -m 640 dobackup.conf.sample ${RPM_BUILD_ROOT}%{_sysconfdir}/dobackup.conf
mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}/cron.d
install -m 640 dobackup.cron ${RPM_BUILD_ROOT}%{_sysconfdir}/cron.d/dobackup
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
install -m 750 dobackup.pl ${RPM_BUILD_ROOT}%{_sbindir}/dobackup
mkdir -m 755 -p ${RPM_BUILD_ROOT}%{_docdir}/dobackup-%{version}
install -m 644 README* CHANGELOG BUGS TODO dobackup.conf.sample dobackup.cron ${RPM_BUILD_ROOT}%{_docdir}/dobackup-%{version}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8
install -m 644 dobackup.8 ${RPM_BUILD_ROOT}%{_mandir}/man8

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc %{_docdir}/dobackup-%{version}
%{_sbindir}/dobackup
%{_mandir}/man8/*
%config(noreplace) %{_sysconfdir}/dobackup.conf
%config(noreplace) %{_sysconfdir}/cron.d/dobackup

%changelog
* %(LC=C date "+%a %b %e %Y") dobackup <dobackup@webcon.ca> %{version}-%{release}
- See %{_docdir}/dobackup-%{version}/CHANGELOG for details.
